<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Subscription extends Model 
{

    protected $table = 'subscription';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function subtype()
    {
        return $this->hasOne('App\Subtype', 'subtype_id');
    }

    public function platform()
    {
        return $this->hasOne('App\Platform', 'platform_id');
    }

    public function country()
    {
        return $this->hasOne('App\Country', 'country_id');
    }

    public function user()
    {
        return $this->hasOne('App\User', 'user_id');
    }

}