<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->unsigned();
			$table->string('name')->index();
			$table->string('login')->unique();
			$table->string('userid', 8)->unique();
			$table->integer('partner_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}