<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Login extends Eloquent {

	protected $table = 'login';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->hasOne('App\User', 'user_id');
	}

	public function country()
	{
		return $this->hasOne('App\Country', 'ipcountry_id');
	}

}