<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Club extends Eloquent {

	protected $table = 'clubs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'company_name', 'logo', 'location', 'grade');

	public function events()
	{
		return $this->hasMany('Event');
	}

}