<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'image', 'description', 'themes_id', 'location', 'scheduled_publish_date', 'active');

	public function clubs()
	{
		return $this->belongsTo('Club');
	}

}