<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 100);
			$table->string('passwordTxt', 50);
			$table->string('password', 255);
			$table->string('nombre', 150);
			$table->string('aPaterno', 150);
			$table->string('aMaterno', 150);
			$table->enum('genero', array('M', 'F'));
			$table->string('nacionalidad', 80);
			$table->date('fechaNac');
			$table->string('calle', 255);
			$table->string('numExterior', 10);
			$table->string('numInterior', 10);
			$table->string('colonia', 255);
			$table->integer('idPais');
			$table->integer('idEstado');
			$table->integer('idMunicipio');
			$table->string('cp', 15);
			$table->string('cveLD', 10);
			$table->string('tel', 20);
			$table->string('telOficina', 20);
			$table->string('ext', 20);
			$table->string('telCelular', 20);
			$table->string('fax', 20);
			$table->string('email', 255)->unique();
			$table->string('emailVerif', 255);
			$table->enum('estatus', array('A', 'B', 'S'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}