<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssetsTable extends Migration {

	public function up()
	{
		Schema::create('assets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('location');
			$table->integer('model');
			$table->integer('model_supplier');
			$table->string('asset_code');
			$table->string('alias');
			$table->date('deployment_date');
			$table->date('commisioning_date');
			$table->tinyInteger('status');
		});
	}

	public function down()
	{
		Schema::drop('assets');
	}
}