<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAmountCashStatementsCurrenciesTable extends Migration {

	public function up()
	{
		Schema::create('amount_cash_statements_currencies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('cash_statement_id')->unsigned()->nullable();
			$table->integer('currency_id')->unsigned()->nullable();
			$table->string('amount', 255)->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('amount_cash_statements_currencies');
	}
}