<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAuditReportsTable extends Migration {

	public function up()
	{
		Schema::create('audit_reports', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('cash_statement_id')->unsigned()->nullable();
			$table->string('slug', 225)->nullable();
			$table->text('audit_comment')->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('audit_reports');
	}
}