<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Box extends Eloquent {

	protected $table = 'boxes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('agency_id', 'slug', 'name', 'alert_threshold', 'status');
	protected $visible = array('agency_id', 'slug', 'name', 'alert_threshold', 'status');

	public function transfers()
	{
		return $this->hasMany('App\Models\Transfer', 'box_id');
	}

	public function exchanges()
	{
		return $this->hasMany('App\Models\Exchange', 'box_id');
	}

	public function agency()
	{
		return $this->belongsTo('App\Models\Agency', 'agency_id');
	}

	public function usersBox()
	{
		return $this->hasMany('App\Models\UserBox', 'box_id');
	}

	public function commissions()
	{
		return $this->hasMany('App\Models\Commission', 'box_id');
	}

}