<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('phone', 'password', 'name', 'bank_id', 'type', 'category_id', 'active', 'api_token', 'remember_token', 'language', 'description', 'latitude', 'longitude', 'membership_num', 'commission', 'logo', 'file', 'arranging', 'last_login_at', 'last_login_ip', 'trade_register', 'bank_account', 'point_equal_SR');
	protected $hidden = array('password');

	public function bank()
	{
		return $this->belongsTo('App\Models\Bank', 'bank_id');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\Category', 'category_id');
	}

	public function records()
	{
		return $this->hasMany('App\Models\Record', 'user_id');
	}

	public function suggestions()
	{
		return $this->hasMany('App\Models\Suggestion', 'user_id');
	}

	public function points()
	{
		return $this->hasMany('App\Models\Point', 'user_id');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification', 'user_id');
	}

	public function storeNotifications()
	{
		return $this->hasMany('App\Models\Notification', 'store_id');
	}

	public function transactions()
	{
		return $this->hasMany('App\Models\Transaction', 'user_id');
	}

	public function storeTransactions()
	{
		return $this->hasMany('App\Models\Transaction', 'store_id');
	}

	public function rates()
	{
		return $this->hasMany('App\Models\Rate', 'user_id');
	}

	public function storeRates()
	{
		return $this->hasMany('App\Models\Rate', 'store_id');
	}

	public function sliders()
	{
		return $this->hasMany('App\Models\Slider', 'user_id');
	}

	public function device()
	{
		return $this->hasOne('App\Models\Device', 'user_id');
	}

}