<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('Profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('name', 255)->nullable()->default('§');
			$table->string('surname', 255);
			$table->tinyInteger('admin')->nullable();
			$table->string('profile_picture', 255);
			$table->string('phone_number', 255);
			$table->string('address', 255);
			$table->string('organization', 255);
			$table->string('website', 255);
			$table->date('birthdate_date');
			$table->tinyInteger('email_notifications');
			$table->datetime('deleted_at');
			$table->timestamp('created_at');
			$table->string('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('Profiles');
	}
}