<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('date');
			$table->boolean('notification')->default(0);
			$table->float('amount')->default('0');
			$table->integer('user_id');
			$table->integer('wallet_id');
			$table->integer('category_id');
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}