<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('main_category_id');
			$table->integer('category_id');
			$table->timestamps();
			$table->integer('old_price');
			$table->integer('price');
			$table->string('code');
			$table->string('description');
			$table->integer('receipt_id')->unsigned();
			$table->integer('quantity');
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}