<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('plan_id')->unsigned();
			$table->double('period_amount')->nullable();
			$table->string('period_unit')->nullable();
			$table->double('price');
			$table->double('commission')->nullable();
			$table->tinyInteger('test')->default('0');
			$table->tinyInteger('version')->nullable();
			$table->text('note')->nullable();
			$table->string('image', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}