<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model 
{

    protected $table = 'tickets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $visible = array('roleID');

    public function Role()
    {
        return $this->belongsTo('Role', 'id');
    }

    public function User()
    {
        return $this->belongsTo('User', 'id');
    }

    public function technologies()
    {
        return $this->hasMany('Technology', 'id');
    }

    public function affected()
    {
        return $this->hasMany('Affected', 'id');
    }

    public function onCallTech()
    {
        return $this->hasOne('User', 'id');
    }

    public function bidQuotes()
    {
        return $this->hasMany('BidQuote', 'id');
    }

}