<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBidQuotesTable extends Migration {

	public function up()
	{
		Schema::create('bidQuotes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('ticketID')->unsigned();
			$table->integer('userID')->unsigned();
			$table->softDeletes();
			$table->boolean('partAvailable')->default(0);
			$table->boolean('crewAvailble')->default(0);
			$table->string('crewNamesPhones')->nullable();
			$table->datetime('etaOnSite')->nullable();
			$table->integer('manLift')->default('0');
			$table->float('quote', 10,2);
			$table->string('comment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('bidQuotes');
	}
}