<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TicketLife extends Eloquent {

	protected $table = 'ticketLife';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function ticket()
	{
		return $this->belongsTo('Ticket', 'id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'id');
	}

}