<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('tier_id')->unsigned();
			$table->date('start_date');
			$table->date('expiry_date');
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}