<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('admins')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('profits', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tickets_messages', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('tickets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_packages', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_packages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('profits_times', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_affiliates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('withdraw', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('convert_profit', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('referral_profits', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_admin_id_foreign');
		});
		Schema::table('profits', function(Blueprint $table) {
			$table->dropForeign('profits_user_id_foreign');
		});
		Schema::table('tickets_messages', function(Blueprint $table) {
			$table->dropForeign('tickets_messages_ticket_id_foreign');
		});
		Schema::table('users_packages', function(Blueprint $table) {
			$table->dropForeign('users_packages_package_id_foreign');
		});
		Schema::table('users_packages', function(Blueprint $table) {
			$table->dropForeign('users_packages_user_id_foreign');
		});
		Schema::table('profits_times', function(Blueprint $table) {
			$table->dropForeign('profits_times_package_id_foreign');
		});
		Schema::table('users_affiliates', function(Blueprint $table) {
			$table->dropForeign('users_affiliates_user_id_foreign');
		});
		Schema::table('withdraw', function(Blueprint $table) {
			$table->dropForeign('withdraw_user_id_foreign');
		});
		Schema::table('convert_profit', function(Blueprint $table) {
			$table->dropForeign('convert_profit_user_id_foreign');
		});
		Schema::table('referral_profits', function(Blueprint $table) {
			$table->dropForeign('referral_profits_user_id_foreign');
		});
	}
}