<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstitutesTable extends Migration {

	public function up()
	{
		Schema::create('institutes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('phone_number', 255);
			$table->longText('breif');
			$table->string('email', 191);
			$table->text('address');
			$table->decimal('latitudes');
			$table->decimal('longitudes');
			$table->string('course_type', 255);
			$table->string('institute_link', 255)->nullable();
			$table->integer('city_id')->unsigned();
			$table->string('date', 255);
			$table->integer('admin_id')->unsigned();
			$table->text('feature');
		});
	}

	public function down()
	{
		Schema::drop('institutes');
	}
}