<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->float('battery')->nullable();
			$table->float('liquid_height')->nullable();
			$table->float('liquid_temperature')->nullable();
			$table->float('percent')->nullable();
			$table->integer('remaining_day')->nullable();
			$table->integer('tank_id')->unsigned();
			$table->integer('type_notification_id')->unsigned();
			$table->float('volume')->nullable();
			$table->integer('company_user_service_station_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}