<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDepotagesTable extends Migration {

	public function up()
	{
		Schema::create('depotages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->datetime('end_at')->nullable();
			$table->float('end_liquid_temperature')->nullable();
			$table->float('end_height')->nullable();
			$table->float('end_volume')->nullable();
			$table->float('start_height')->nullable();
			$table->float('start_liquid_temperature')->nullable();
			$table->float('start_volume')->nullable();
			$table->string('status')->default('true');
			$table->datetime('take_at')->nullable();
			$table->integer('tank_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('depotages');
	}
}