<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecordsTable extends Migration {

	public function up()
	{
		Schema::create('records', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->float('battery_level')->nullable();
			$table->double('density')->nullable();
			$table->integer('depotage')->nullable();
			$table->float('env_temperature')->nullable();
			$table->double('level')->nullable();
			$table->double('liquid_height')->nullable();
			$table->float('liquid_temperature')->nullable();
			$table->string('sensor_reference')->nullable();
			$table->integer('tank_id')->unsigned();
			$table->float('total_volume')->nullable();
			$table->float('volume')->nullable();
			$table->float('volume_at_fift')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('records');
	}
}