<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CompanyUserServiceStation extends Eloquent {

	protected $table = 'company_user_service_stations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('service_station_id', 'user_id', 'company_id');
	protected $visible = array('service_station_id', 'user_id', 'company_id');

	public function service_station()
	{
		return $this->belongsTo('ServiceStation', 'service_station_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function notifications()
	{
		return $this->hasMany('Notification');
	}

	public function company()
	{
		return $this->belongsTo('Company', 'company_id');
	}

}