<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notification extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('battery', 'liquid_height', 'liquid_temperature', 'percent', 'remaining_day', 'tank_id', 'type_notification_id', 'volume', 'company_user_service_station_id');
	protected $visible = array('battery', 'liquid_height', 'liquid_temperature', 'percent', 'remaining_day', 'tank_id', 'type_notification_id', 'volume', 'company_user_service_station_id');

	public function tank()
	{
		return $this->belongsTo('Tank', 'tank_id');
	}

	public function type_notification()
	{
		return $this->belongsTo('TypeNotification', 'type_notification');
	}

	public function company_user_stationservice()
	{
		return $this->belongsTo('CompanyUserServiceStation', 'company_user_stationservice_id');
	}

}