<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductStationTank extends Eloquent {

	protected $table = 'product_station_tanks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_id', 'service_station_id', 'pistolets');
	protected $visible = array('product_id', 'service_station_id', 'pistolets');

	public function tanks()
	{
		return $this->hasMany('Tank');
	}

	public function service_station()
	{
		return $this->belongsTo('ServiceStation', 'service_station_id');
	}

	public function product()
	{
		return $this->belongsTo('Product', 'product_id');
	}

}