<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RemainingNotificationParameter extends Eloquent {

	protected $table = 'remaining_notification_parameters';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('scdp_delay_day', 'critic_limit', 'service_station_id');
	protected $visible = array('scdp_delay_day', 'critic_limit', 'service_station_id');

	public function service_station()
	{
		return $this->belongsTo('ServiceStation', 'service_station_id');
	}

}