<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ServiceStation extends Eloquent {

	protected $table = 'service_stations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'town_id', 'latitude', 'longitude', 'status', 'back_image_link', 'address', 'gmt');
	protected $visible = array('name', 'description', 'town_id', 'latitude', 'longitude', 'status', 'back_image_link', 'address', 'gmt');

	public function town()
	{
		return $this->belongsTo('Town', 'town_id');
	}

	public function company_user_service_stations()
	{
		return $this->hasMany('CompanyUserServiceStation');
	}

	public function quartWorkings()
	{
		return $this->hasMany('QuartWorking');
	}

	public function product_station_tanks()
	{
		return $this->hasMany('ProductStationTank');
	}

	public function remaining_notification_parameter()
	{
		return $this->hasOne('RemainingNotificationParameter');
	}

}