<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('adress', 'profil_image', 'email', 'first_name', 'last_name', 'password', 'phone', 'status', 'token', 'is_confirm', 'private_mail', 'is_first_conn');
	protected $visible = array('adress', 'profil_image', 'email', 'first_name', 'last_name', 'password', 'phone', 'status', 'token', 'is_confirm', 'private_mail', 'is_first_conn');

	public function company_user_service_stations()
	{
		return $this->hasMany('CompanyUserServiceStation');
	}

}