<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentMethodTable extends Migration {

	public function up()
	{
		Schema::create('payment_method', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->bigInteger('customer_id');
			$table->string('card_num')->nullable();
			$table->date('expire_date')->nullable();
			$table->string('password')->nullable();
			$table->string('type')->nullable();
			$table->text('note');
			$table->string('extra1')->nullable();
			$table->string('extra2')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payment_method');
	}
}