<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContratsTable extends Migration {

	public function up()
	{
		Schema::create('contrats', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->boolean('valide')->nullable();
			$table->decimal('prix');
			$table->boolean('signe')->nullable();
			$table->boolean('annule')->nullable();
			$table->enum('etatCommande', array('recu', 'preparation', 'installee', 'facturee'))->nullable();
			$table->integer('id_client')->unsigned();
			$table->integer('id_employe')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('contrats');
	}
}