<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProduitsTable extends Migration {

	public function up()
	{
		Schema::create('produits', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('reference', 100);
			$table->string('libelle', 200);
			$table->text('description')->nullable();
			$table->text('specifications')->nullable();
			$table->decimal('prixAchat');
			$table->decimal('prixVente');
			$table->decimal('tva')->nullable();
			$table->string('photo', 500)->nullable();
			$table->boolean('publie')->nullable();
			$table->integer('qteStock');
			$table->integer('seuilAppro')->nullable();
			$table->boolean('annule')->nullable();
			$table->integer('id_famille')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('produits');
	}
}