<?php

namespace App/models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Vente extends Eloquent {

	protected $table = 'Ventes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('montant');

	public function bienimmobiliere()
	{
		return $this->belongsTo('BienImmobilieres');
	}

	public function utilisateur()
	{
		return $this->belongsTo('User');
	}

}