<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserMetaTable extends Migration {

	public function up()
	{
		Schema::create('user_meta', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('role_id')->unsigned();
			$table->timestamps();
			$table->string('company_name')->nullable();
			$table->string('company_role')->nullable();
			$table->text('biography')->nullable();
			$table->string('phone')->nullable();
			$table->string('country')->nullable();
			$table->string('state')->nullable();
			$table->string('city')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_meta');
	}
}