<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_meta', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_meta', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('media_list_regions', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('media_list_items', function(Blueprint $table) {
			$table->foreign('media_list_type_id')->references('id')->on('media_list_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('media_list_items', function(Blueprint $table) {
			$table->foreign('media_list_id')->references('id')->on('media_lists')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('media_list_items', function(Blueprint $table) {
			$table->foreign('media_list_outlet_id')->references('id')->on('media_list_outlets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('media_list_items', function(Blueprint $table) {
			$table->foreign('media_list_category_id')->references('id')->on('media_list_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('media_list_items', function(Blueprint $table) {
			$table->foreign('media_list_region_id')->references('id')->on('media_list_regions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('media_list_region_outlet', function(Blueprint $table) {
			$table->foreign('media_list_region_id')->references('id')->on('media_list_regions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('media_list_region_outlet', function(Blueprint $table) {
			$table->foreign('media_list_outlet_id')->references('id')->on('media_list_outlets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('media_list_category_outlet', function(Blueprint $table) {
			$table->foreign('media_list_category_id')->references('id')->on('media_list_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('media_list_category_outlet', function(Blueprint $table) {
			$table->foreign('media_list_outlet_id')->references('id')->on('media_list_outlets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('media_list_type_outlet', function(Blueprint $table) {
			$table->foreign('media_list_type_id')->references('id')->on('media_list_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('media_list_type_outlet', function(Blueprint $table) {
			$table->foreign('media_list_outlet_id')->references('id')->on('media_list_outlets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('user_meta', function(Blueprint $table) {
			$table->dropForeign('user_meta_user_id_foreign');
		});
		Schema::table('user_meta', function(Blueprint $table) {
			$table->dropForeign('user_meta_role_id_foreign');
		});
		Schema::table('media_list_regions', function(Blueprint $table) {
			$table->dropForeign('media_list_regions_country_id_foreign');
		});
		Schema::table('media_list_items', function(Blueprint $table) {
			$table->dropForeign('media_list_items_media_list_type_id_foreign');
		});
		Schema::table('media_list_items', function(Blueprint $table) {
			$table->dropForeign('media_list_items_media_list_id_foreign');
		});
		Schema::table('media_list_items', function(Blueprint $table) {
			$table->dropForeign('media_list_items_media_list_outlet_id_foreign');
		});
		Schema::table('media_list_items', function(Blueprint $table) {
			$table->dropForeign('media_list_items_media_list_category_id_foreign');
		});
		Schema::table('media_list_items', function(Blueprint $table) {
			$table->dropForeign('media_list_items_media_list_region_id_foreign');
		});
		Schema::table('media_list_region_outlet', function(Blueprint $table) {
			$table->dropForeign('media_list_region_outlet_media_list_region_id_foreign');
		});
		Schema::table('media_list_region_outlet', function(Blueprint $table) {
			$table->dropForeign('media_list_region_outlet_media_list_outlet_id_foreign');
		});
		Schema::table('media_list_category_outlet', function(Blueprint $table) {
			$table->dropForeign('media_list_category_outlet_media_list_category_id_foreign');
		});
		Schema::table('media_list_category_outlet', function(Blueprint $table) {
			$table->dropForeign('media_list_category_outlet_media_list_outlet_id_foreign');
		});
		Schema::table('media_list_type_outlet', function(Blueprint $table) {
			$table->dropForeign('media_list_type_outlet_media_list_type_id_foreign');
		});
		Schema::table('media_list_type_outlet', function(Blueprint $table) {
			$table->dropForeign('media_list_type_outlet_media_list_outlet_id_foreign');
		});
	}
}