<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('Client')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('Client')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('food_item', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('Client')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('food_item', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('food_size_options', function(Blueprint $table) {
			$table->foreign('food_item_id')->references('id')->on('food_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('food_customization_type', function(Blueprint $table) {
			$table->foreign('food_item_id')->references('id')->on('food_item')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_client_id_foreign');
		});
		Schema::table('category', function(Blueprint $table) {
			$table->dropForeign('category_client_id_foreign');
		});
		Schema::table('food_item', function(Blueprint $table) {
			$table->dropForeign('food_item_client_id_foreign');
		});
		Schema::table('food_item', function(Blueprint $table) {
			$table->dropForeign('food_item_category_id_foreign');
		});
		Schema::table('food_size_options', function(Blueprint $table) {
			$table->dropForeign('food_size_options_food_item_id_foreign');
		});
		Schema::table('food_customization_type', function(Blueprint $table) {
			$table->dropForeign('food_customization_type_food_item_id_foreign');
		});
	}
}