<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_id')->unsigned();
			$table->bigInteger('product_id')->unsigned();
			$table->string('product_name', 191);
			$table->string('product_image', 191);
			$table->longText('product_description');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}