<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoasOfOrgsTable extends Migration {

	public function up()
	{
		Schema::create('coas_of_orgs', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('id_with_org')->unique()->nullable();
			$table->integer('id_org')->unsigned()->nullable();
			$table->string('code', 200);
			$table->string('name', 200);
			$table->bigInteger('saldo');
			$table->integer('id_head_account')->unsigned()->nullable();
			$table->bigInteger('id_parent_with_org')->unsigned()->nullable();
			$table->integer('is_lock')->nullable();
			$table->timestamps();
			$table->longText('description')->nullable();
			$table->bigInteger('id_coa_category')->unsigned()->nullable()->default('1');
		});
	}

	public function down()
	{
		Schema::drop('coas_of_orgs');
	}
}