<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('id_with_org')->unique()->nullable();
			$table->bigInteger('id_org')->unsigned();
			$table->string('trs_code', 200);
			$table->integer('trs_type')->nullable()->default('1');
			$table->timestamp('trs_date');
			$table->longText('trs_desc')->nullable();
			$table->string('trs_ref', 200)->nullable();
			$table->string('trs_pic', 200)->nullable();
			$table->string('trs_ket', 100)->nullable();
			$table->integer('trs_via')->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}