<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UserCollection extends Model 
{

    protected $table = 'gooddreamer_user_collection';
    public $timestamps = false;
    protected $fillable = array('id', 'user_id', 'novel_id', 'type', 'hidden', 'expired_at', 'created_at', 'hidden_at');
    protected $visible = array('id', 'user_id', 'novel_id', 'type', 'hidden', 'expired_at', 'created_at', 'hidden_at');

    public function user()
    {
        return $this->belongsToMany('User');
    }

    public function novel()
    {
        return $this->belongsToMany('Novel');
    }

    public function novelProgression()
    {
        return $this->hasMany('NovelProgression', 'uc_id');
    }

}