<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerNotificationSchedulerTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_notification_scheduler', function(Blueprint $table) {
			$table->integer('id', true);
			$table->text('ns_content');
			$table->string('ns_path', 255)->nullable();
			$table->string('ns_filename', 255)->nullable();
			$table->datetime('ns_start_date');
			$table->datetime('ns_end_date');
			$table->time('ns_hour');
			$table->string('ns_repeat_day', 255);
			$table->tinyInteger('active')->default('1');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('deleted_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_notification_scheduler');
	}
}