<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGooddreamerUserCollectionTable extends Migration {

	public function up()
	{
		Schema::create('gooddreamer_user_collection', function(Blueprint $table) {
			$table->integer('id', true)->primary();
			$table->integer('user_id')->unsigned()->index();
			$table->integer('novel_id')->unsigned()->index();
			$table->tinyInteger('type')->default('1');
			$table->tinyInteger('hidden')->default('0');
			$table->datetime('expired_at')->nullable();
			$table->datetime('created_at');
			$table->datetime('hidden_at');
		});
	}

	public function down()
	{
		Schema::drop('gooddreamer_user_collection');
	}
}