<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStockOperationsTable extends Migration {

	public function up()
	{
		Schema::create('StockOperations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('Réception', 'sortie'));
			$table->string('Label', 250);
			$table->string('Referance', 250);
			$table->string('Source_destination', 250);
			$table->bigInteger('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('StockOperations');
	}
}