<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('username', 30)->unique();
			$table->string('email', 40)->unique();
			$table->string('password', 80);
			$table->string('remember_token', 100);
			$table->boolean('banned')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}