<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('Customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('country', 191);
			$table->string('governorate', 191);
			$table->string('Region', 191);
			$table->string('address', 191);
			$table->string('company', 191);
			$table->integer('tax_num');
			$table->enum('type', array('part', 'fulltime'));
			$table->string('photo', 191);
			$table->integer('mobile1');
			$table->string('mobile2');
			$table->integer('phone');
			$table->integer('fax');
			$table->string('email', 191);
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('Customers');
	}
}