<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->date('date');
			$table->tinyInteger('type')->default('0');
			$table->decimal('price');
			$table->string('beneficiary', 191);
			$table->integer('t_exchange');
			$table->bigInteger('safe_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}