<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('delivery_id')->references('id')->on('deliveries')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('client_delivery', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('client_delivery', function(Blueprint $table) {
			$table->foreign('delivery_id')->references('id')->on('deliveries')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_client_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_delivery_id_foreign');
		});
		Schema::table('client_delivery', function(Blueprint $table) {
			$table->dropForeign('client_delivery_client_id_foreign');
		});
		Schema::table('client_delivery', function(Blueprint $table) {
			$table->dropForeign('client_delivery_delivery_id_foreign');
		});
	}
}