<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function threads()
	{
		return $this->hasMany('Thread');
	}

	public function posts()
	{
		return $this->hasMany('Post');
	}

	public function polls()
	{
		return $this->hasMany('Poll');
	}

	public function notifications()
	{
		return $this->hasMany('Notification');
	}

}