<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function collections()
    {
        return $this->hasMany('Collection');
    }

    public function posts()
    {
        return $this->hasMany('Post');
    }

    public function uploads()
    {
        return $this->hasMany('Upload');
    }

}